<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cdokter extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('M_Dokter_Admin','M_Dokter');
    }

    public function index()
    {
        $this->load->helper('url');
        $this->load->view('dokter_admin');
    }

    public function ajax_list()
    {
        $this->load->helper('url');

        $list = $this->M_Dokter->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $dok) {
            $no++;
            $row = array();
            $row[] = $dok->nama_dokter;
            $row[] = $dok->spesialis;
  
            if($dok->foto_dokter)
                $row[] = '<a href="'.base_url('upload/dokter/'.$dok->foto_dokter).'" target="_blank"><img src="'.base_url('upload/dokter/'.$dok->foto_dokter).'" class="img-responsive" /></a>';
            else
                $row[] = '(No foto_dokter)';

            //add html for action
            $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_dokter('."'".$dok->id."'".')"><i class="glyphicon glyphicon-pencil"></i> Edit</a>
                  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Hapus" onclick="delete_dokter('."'".$dok->id."'".')"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
        
            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->M_Dokter->count_all(),
                        "recordsFiltered" => $this->M_Dokter->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_edit($id)
    {
        $data = $this->M_Dokter->get_by_id($id);
     
        echo json_encode($data);
    }

    public function ajax_add()
    {
        $this->_validate();
        
        $data = array(
                'nama_dokter' => $this->input->post('nama_dokter'),
                'spesialis' => $this->input->post('spesialis'),
   
            );

        if(!empty($_FILES['foto_dokter']['name']))
        {
            $upload = $this->_do_upload();
            $data['foto_dokter'] = $upload;
        }

        $insert = $this->M_Dokter->save($data);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update()
    {
        $this->_validate();
        $data = array(
                'nama_dokter' => $this->input->post('nama_dokter'),
                'spesialis' => $this->input->post('spesialis'),
   
            );
        if($this->input->post('remove_foto_dokter')) // if remove foto_dokter checked
        {
            if(file_exists('upload/dokter/'.$this->input->post('remove_foto_dokter')) && $this->input->post('remove_foto_dokter'))
                unlink('upload/dokter/'.$this->input->post('remove_foto_dokter'));
            $data['foto_dokter'] = '';
        }

        if(!empty($_FILES['foto_dokter']['name']))
        {
            $upload = $this->_do_upload();
            
            //delete file
            $dok = $this->M_Dokter->get_by_id($this->input->post('id'));
            if(file_exists('upload/dokter/'.$dok->foto_dokter) && $dok->foto_dokter)
                unlink('upload/dokter/'.$dok->foto_dokter);

            $data['foto_dokter'] = $upload;
        }

        $this->M_Dokter->update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete($id)
    {
        //delete file
        $dok = $this->M_Dokter->get_by_id($id);
        if(file_exists('upload/dokter/'.$dok->foto_dokter) && $dok->foto_dokter)
            unlink('upload/dokter/'.$dok->foto_dokter);
        
        $this->M_Dokter->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    private function _do_upload()
    {
        $config['upload_path']          = 'upload/dokter/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['max_size']             = 1000; //set max size allowed in Kilobyte
        $config['max_width']            = 1920; // set max width image allowed
        $config['max_height']           = 700; // set max height allowed
        $config['file_name']            = round(microtime(true) * 1000); //just milisecond timestamp fot unique name

        $this->load->library('upload', $config);

        if(!$this->upload->do_upload('foto_dokter')) //upload and validate
        {
            $data['inputerror'][] = 'foto_dokter';
            $data['error_string'][] = 'Upload error: '.$this->upload->display_errors('',''); //show ajax error
            $data['status'] = FALSE;
            echo json_encode($data);
            exit();
        }
        return $this->upload->data('file_name');
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if($this->input->post('nama_dokter') == '')
        {
            $data['inputerror'][] = 'nama_dokter';
            $data['error_string'][] = 'Nama Dokter is required';
            $data['status'] = FALSE;
        }

        if($this->input->post('spesialis') == '')
        {
            $data['inputerror'][] = 'spesialis';
            $data['error_string'][] = 'Spesialis is required';
            $data['status'] = FALSE;
        }

        

        if($data['status'] === FALSE)
        {
            echo json_encode($data);
            exit();
        }
    }

}
