<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Crsisytrending extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('M_Rsisy_Trending','M_Trend');
    }

    public function index()
    {
        $this->load->helper('url');
        $this->load->view('rsisy_trending_admin');
    }

    public function ajax_list()
    {
        $this->load->helper('url');

        $list = $this->M_Trend->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $trend) {
            $no++;
            $row = array();
            $row[] = $trend->judul;
            $row[] = $trend->cuplikan_trend;
            $row[] = $trend->link;
  
            if($trend->gambar_trend)
                $row[] = '<a href="'.base_url('upload/rsisy_trending/'.$trend->gambar_trend).'" target="_blank"><img src="'.base_url('upload/rsisy_trending/'.$trend->gambar_trend).'" class="img-responsive" /></a>';
            else
                $row[] = '(No Gambar)';

            //add html for action
            $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_trend('."'".$trend->id."'".')"><i class="glyphicon glyphicon-pencil"></i> Edit</a>
                  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Hapus" onclick="delete_trend('."'".$trend->id."'".')"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
        
            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->M_Trend->count_all(),
                        "recordsFiltered" => $this->M_Trend->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_edit($id)
    {
        $data = $this->M_Trend->get_by_id($id);
     
        echo json_encode($data);
    }

    public function ajax_add()
    {
        $this->_validate();
        
        $data = array(
                'judul' => $this->input->post('judul'),
                'cuplikan_trend' => $this->input->post('cuplikan_trend'),
                'link' => $this->input->post('link'),
   
            );

        if(!empty($_FILES['gambar_trend']['name']))
        {
            $upload = $this->_do_upload();
            $data['gambar_trend'] = $upload;
        }

        $insert = $this->M_Trend->save($data);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update()
    {
        $this->_validate();
        $data = array(
                'judul' => $this->input->post('judul'),
                'cuplikan_trend' => $this->input->post('cuplikan_trend'),
                'link' => $this->input->post('link'),
   
            );
        if($this->input->post('remove_gambar_trend')) // if remove gambar_trend checked
        {
            if(file_exists('upload/rsisy_trending/'.$this->input->post('remove_gambar_trend')) && $this->input->post('remove_gambar_trend'))
                unlink('upload/rsisy_trending/'.$this->input->post('remove_gambar_trend'));
            $data['gambar_trend'] = '';
        }

        if(!empty($_FILES['gambar_trend']['name']))
        {
            $upload = $this->_do_upload();
            
            //delete file
            $trend = $this->M_Trend->get_by_id($this->input->post('id'));
            if(file_exists('upload/rsisy_trending/'.$trend->gambar_trend) && $trend->gambar_trend)
                unlink('upload/rsisy_trending/'.$trend->gambar_trend);

            $data['gambar_trend'] = $upload;
        }

        $this->M_Trend->update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete($id)
    {
        //delete file
        $trend = $this->M_Trend->get_by_id($id);
        if(file_exists('upload/rsisy_trending/'.$trend->gambar_trend) && $trend->gambar_trend)
            unlink('upload/rsisy_trending/'.$trend->gambar_trend);
        
        $this->M_Trend->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    private function _do_upload()
    {
        $config['upload_path']          = 'upload/rsisy_trending/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['max_size']             = 1100; //set max size allowed in Kilobyte
        $config['max_width']            = 1100; // set max width image allowed
        $config['max_height']           = 800; // set max height allowed
        $config['file_name']            = round(microtime(true) * 1000); //just milisecond timestamp fot unique name

        $this->load->library('upload', $config);

        if(!$this->upload->do_upload('gambar_trend')) //upload and validate
        {
            $data['inputerror'][] = 'gambar_trend';
            $data['error_string'][] = 'Upload error: '.$this->upload->display_errors('',''); //show ajax error
            $data['status'] = FALSE;
            echo json_encode($data);
            exit();
        }
        return $this->upload->data('file_name');
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if($this->input->post('judul') == '')
        {
            $data['inputerror'][] = 'judul';
            $data['error_string'][] = 'Judul is required';
            $data['status'] = FALSE;
        }

        if($this->input->post('cuplikan_trend') == '')
        {
            $data['inputerror'][] = 'cuplikan_trend';
            $data['error_string'][] = 'Caption is required';
            $data['status'] = FALSE;
        }

        if($this->input->post('link') == '')
        {
            $data['inputerror'][] = 'link';
            $data['error_string'][] = 'Link is required';
            $data['status'] = FALSE;
        }

        

        if($data['status'] === FALSE)
        {
            echo json_encode($data);
            exit();
        }
    }

}
