<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cinfokesehatan extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('M_Info_Kesehatan','Info_Kesehatan');
    }

    public function index()
    {
        $this->load->helper('url');
        $this->load->view('info_kesehatan_admin');
    }

    public function ajax_list()
    {
        $this->load->helper('url');

        $list = $this->Info_Kesehatan->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $info) {
            $no++;
            $row = array();
            $row[] = $info->judul_artikel;
            $row[] = $info->cuplikan;
            //$row[] = $info->isi_artikel;
            $row[] = $info->kategori;
            $row[] = $info->tanggal_posting;
  
            if($info->gambar)
                $row[] = '<a href="'.base_url('upload/artikel/'.$info->gambar).'" target="_blank"><img src="'.base_url('upload/artikel/'.$info->gambar).'" class="img-responsive" /></a>';
            else
                $row[] = '(No gambar)';

            //add html for action
            $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_info_kesehatan('."'".$info->id."'".')"><i class="glyphicon glyphicon-pencil"></i> Edit</a>
                  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Hapus" onclick="delete_info_kesehatan('."'".$info->id."'".')"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
        
            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Info_Kesehatan->count_all(),
                        "recordsFiltered" => $this->Info_Kesehatan->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_edit($id)
    {
        $data = $this->Info_Kesehatan->get_by_id($id);
     
        echo json_encode($data);
    }

    public function ajax_add()
    {
        $this->_validate();
        
        $data = array(
                'judul_artikel' => $this->input->post('judul_artikel'),
                'cuplikan' => $this->input->post('cuplikan'),
                'isi_artikel' => $this->input->post('isi_artikel'),
                'kategori' => $this->input->post('kategori'),
                'tanggal_posting' => $this->input->post('tanggal_posting'),
            );

        if(!empty($_FILES['gambar']['name']))
        {
            $upload = $this->_do_upload();
            $data['gambar'] = $upload;
        }

        $insert = $this->Info_Kesehatan->save($data);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update()
    {
        $this->_validate();
        $data = array(
                'judul_artikel' => $this->input->post('judul_artikel'),
                'cuplikan' => $this->input->post('cuplikan'),
                'isi_artikel' => $this->input->post('isi_artikel'),
                'kategori' => $this->input->post('kategori'),
                'tanggal_posting' => $this->input->post('tanggal_posting'),
  
            );

        if($this->input->post('remove_gambar')) // if remove gambar checked
        {
            if(file_exists('upload/artikel/'.$this->input->post('remove_gambar')) && $this->input->post('remove_gambar'))
                unlink('upload/artikel/'.$this->input->post('remove_gambar'));
            $data['gambar'] = '';
        }

        if(!empty($_FILES['gambar']['name']))
        {
            $upload = $this->_do_upload();
            
            //delete file
            $info = $this->Info_Kesehatan->get_by_id($this->input->post('id'));
            if(file_exists('upload/artikel/'.$info->gambar) && $info->gambar)
                unlink('upload/artikel/'.$info->gambar);

            $data['gambar'] = $upload;
        }

        $this->Info_Kesehatan->update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete($id)
    {
        //delete file
        $info = $this->Info_Kesehatan->get_by_id($id);
        if(file_exists('upload/artikel/'.$info->gambar) && $info->gambar)
            unlink('upload/artikel/'.$info->gambar);
        
        $this->Info_Kesehatan->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    private function _do_upload()
    {
        $config['upload_path']          = 'upload/artikel/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['max_size']             = 1000; //set max size allowed in Kilobyte
        $config['max_width']            = 1920; // set max width image allowed
        $config['max_height']           = 700; // set max height allowed
        $config['file_name']            = round(microtime(true) * 1000); //just milisecond timestamp fot unique name

        $this->load->library('upload', $config);

        if(!$this->upload->do_upload('gambar')) //upload and validate
        {
            $data['inputerror'][] = 'gambar';
            $data['error_string'][] = 'Upload error: '.$this->upload->display_errors('',''); //show ajax error
            $data['status'] = FALSE;
            echo json_encode($data);
            exit();
        }
        return $this->upload->data('file_name');
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if($this->input->post('judul_artikel') == '')
        {
            $data['inputerror'][] = 'judul_artikel';
            $data['error_string'][] = 'Judul is required';
            $data['status'] = FALSE;
        }

        

        if($data['status'] === FALSE)
        {
            echo json_encode($data);
            exit();
        }
    }

}
