<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ckamar extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('M_Kamar');
    }

    public function index()
    {
        $this->load->helper('url');
        $this->load->view('info_kamar_admin');
    }

    public function ajax_list()
    {
        $this->load->helper('url');

        $list = $this->M_Kamar->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $kamar) {
            $no++;
            $row = array();
            $row[] = $kamar->judul;
            $row[] = $kamar->isi;
            $row[] = $kamar->harga;
  
            if($kamar->gambar_1)
                $row[] = '<a href="'.base_url('upload/info_kamar/'.$kamar->gambar_1).'" target="_blank"><img src="'.base_url('upload/info_kamar/'.$kamar->gambar_1).'" class="img-responsive" /></a>';
            else
                $row[] = '(No Gambar)';

            //add html for action
            $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_kamar('."'".$kamar->id."'".')"><i class="glyphicon glyphicon-pencil"></i> Edit</a><br><br>
                  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Hapus" onclick="delete_kamar('."'".$kamar->id."'".')"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
        
            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->M_Kamar->count_all(),
                        "recordsFiltered" => $this->M_Kamar->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_edit($id)
    {
        $data = $this->M_Kamar->get_by_id($id);
     
        echo json_encode($data);
    }

    public function ajax_add()
    {
        $this->_validate();
        
        $data = array(
                'judul' => $this->input->post('judul'),
                'isi' => $this->input->post('isi'),
                'harga' => $this->input->post('harga'),
   
            );

        if(!empty($_FILES['gambar_1']['name']))
        {
            $upload = $this->_do_upload();
            $data['gambar_1'] = $upload;
        }

        $insert = $this->M_Kamar->save($data);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update()
    {
        $this->_validate();
        $data = array(
                'judul' => $this->input->post('judul'),
                'isi' => $this->input->post('isi'),
                'harga' => $this->input->post('harga'),
   
            );
        if($this->input->post('remove_gambar_1')) // if remove gambar_1 checked
        {
            if(file_exists('upload/info_kamar/'.$this->input->post('remove_gambar_1')) && $this->input->post('remove_gambar_1'))
                unlink('upload/info_kamar/'.$this->input->post('remove_gambar_1'));
            $data['gambar_1'] = '';
        }

        if(!empty($_FILES['gambar_1']['name']))
        {
            $upload = $this->_do_upload();
            
            //delete file
            $kamar = $this->M_Kamar->get_by_id($this->input->post('id'));
            if(file_exists('upload/info_kamar/'.$kamar->gambar_1) && $kamar->gambar_1)
                unlink('upload/info_kamar/'.$kamar->gambar_1);

            $data['gambar_1'] = $upload;
        }

        $this->M_Kamar->update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete($id)
    {
        //delete file
        $kamar = $this->M_Kamar->get_by_id($id);
        if(file_exists('upload/info_kamar/'.$kamar->gambar_1) && $kamar->gambar_1)
            unlink('upload/info_kamar/'.$kamar->gambar_1);
        
        $this->M_Kamar->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    private function _do_upload()
    {
        $config['upload_path']          = 'upload/info_kamar/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['max_size']             = 1000; //set max size allowed in Kilobyte
        $config['max_width']            = 500; // set max width image allowed
        $config['max_height']           = 500; // set max height allowed
        $config['file_name']            = round(microtime(true) * 1000); //just milisecond timestamp fot unique name

        $this->load->library('upload', $config);

        if(!$this->upload->do_upload('gambar_1')) //upload and validate
        {
            $data['inputerror'][] = 'gambar_1';
            $data['error_string'][] = 'Upload error: '.$this->upload->display_errors('',''); //show ajax error
            $data['status'] = FALSE;
            echo json_encode($data);
            exit();
        }
        return $this->upload->data('file_name');
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if($this->input->post('judul') == '')
        {
            $data['inputerror'][] = 'judul';
            $data['error_string'][] = 'Nama Ruang is required';
            $data['status'] = FALSE;
        }

        if($this->input->post('isi') == '')
        {
            $data['inputerror'][] = 'isi';
            $data['error_string'][] = 'Speck Ruang is required';
            $data['status'] = FALSE;
        }

        if($this->input->post('harga') == '')
        {
            $data['inputerror'][] = 'gambar';
            $data['error_string'][] = 'Speck Ruang is required';
            $data['status'] = FALSE;
        }

        

        if($data['status'] === FALSE)
        {
            echo json_encode($data);
            exit();
        }
    }

}
