<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Csliderbesar extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('M_Slider_Besar','Slider_Besar');
    }

    public function index()
    {
        $this->load->helper('url');
        $this->load->view('slider_besar_admin');
    }

    public function ajax_list()
    {
        $this->load->helper('url');

        $list = $this->Slider_Besar->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $slider) {
            $no++;
            $row = array();
            $row[] = $slider->alt;
  
            if($slider->gambar)
                $row[] = '<a href="'.base_url('upload/slider_besar/'.$slider->gambar).'" target="_blank"><img src="'.base_url('upload/slider_besar/'.$slider->gambar).'" class="img-responsive" /></a>';
            else
                $row[] = '(No gambar)';

            //add html for action
            $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_slider_besar('."'".$slider->id."'".')"><i class="glyphicon glyphicon-pencil"></i> Edit</a>
                  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Hapus" onclick="delete_slider_besar('."'".$slider->id."'".')"><i class="glyphicon glyphicon-trash"></i> Delete</a>';
        
            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->Slider_Besar->count_all(),
                        "recordsFiltered" => $this->Slider_Besar->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function ajax_edit($id)
    {
        $data = $this->Slider_Besar->get_by_id($id);
     
        echo json_encode($data);
    }

    public function ajax_add()
    {
        $this->_validate();
        
        $data = array(
                'alt' => $this->input->post('alt'),
   
            );

        if(!empty($_FILES['gambar']['name']))
        {
            $upload = $this->_do_upload();
            $data['gambar'] = $upload;
        }

        $insert = $this->Slider_Besar->save($data);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update()
    {
        $this->_validate();
        $data = array(
                'alt' => $this->input->post('alt'),
  
            );

        if($this->input->post('remove_gambar')) // if remove gambar checked
        {
            if(file_exists('upload/slider_besar/'.$this->input->post('remove_gambar')) && $this->input->post('remove_gambar'))
                unlink('upload/slider_besar/'.$this->input->post('remove_gambar'));
            $data['gambar'] = '';
        }

        if(!empty($_FILES['gambar']['name']))
        {
            $upload = $this->_do_upload();
            
            //delete file
            $slider = $this->Slider_Besar->get_by_id($this->input->post('id'));
            if(file_exists('upload/slider_besar/'.$slider->gambar) && $slider->gambar)
                unlink('upload/slider_besar/'.$slider->gambar);

            $data['gambar'] = $upload;
        }

        $this->Slider_Besar->update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete($id)
    {
        //delete file
        $slider = $this->Slider_Besar->get_by_id($id);
        if(file_exists('upload/slider_besar/'.$slider->gambar) && $slider->gambar)
            unlink('upload/slider_besar/'.$slider->gambar);
        
        $this->Slider_Besar->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    private function _do_upload()
    {
        $config['upload_path']          = 'upload/slider_besar/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['max_size']             = 1000; //set max size allowed in Kilobyte
        $config['max_width']            = 1920; // set max width image allowed
        $config['max_height']           = 700; // set max height allowed
        $config['file_name']            = round(microtime(true) * 1000); //just milisecond timestamp fot unique name

        $this->load->library('upload', $config);

        if(!$this->upload->do_upload('gambar')) //upload and validate
        {
            $data['inputerror'][] = 'gambar';
            $data['error_string'][] = 'Upload error: '.$this->upload->display_errors('',''); //show ajax error
            $data['status'] = FALSE;
            echo json_encode($data);
            exit();
        }
        return $this->upload->data('file_name');
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if($this->input->post('alt') == '')
        {
            $data['inputerror'][] = 'alt';
            $data['error_string'][] = 'ALT is required';
            $data['status'] = FALSE;
        }

        

        if($data['status'] === FALSE)
        {
            echo json_encode($data);
            exit();
        }
    }

}
