<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Navbar extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model("Navbar_model");
        $this->load->library('form_validation');
    }

    public function index()
    {
        $data["navbar"] = $this->Navbar_model->getAll();
        $this->load->view("_partials/header", $data);
    }

    public function add()
    {
        $navbar = $this->Navbar_model;
        $validation = $this->form_validation;
        $validation->set_rules($navbar->rules());

        if ($validation->run()) {
            $navbar->save();
            $this->session->set_flashdata('success', 'Berhasil disimpan');
        }

        $this->load->view("_partials/header");
    }

    public function edit($id = null)
    {
        if (!isset($id)) redirect('_partials/header');
       
        $navbar = $this->Navbar_model;
        $validation = $this->form_validation;
        $validation->set_rules($navbar->rules());

        if ($validation->run()) {
            $navbar->update();
            $this->session->set_flashdata('success', 'Berhasil disimpan');
        }

        $data["navbar"] = $navbar->getById($id);
        if (!$data["navbar"]) show_404();
        
        $this->load->view("_partials/header", $data);
    }

    public function delete($id=null)
    {
        if (!isset($id)) show_404();
        
        if ($this->Navbar_model->delete($id)) {
            redirect(site_url('_partials/header'));
        }
    }
}

