<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Dokter_model extends CI_Model
{
    private $_table = "dokter_yarsis";

    public $id_dokter;
    public $nama_dokter;
    public $spesialis;
    public $jadwal_igd;
    public $jadwal_poli;
    public $foto_dokter;

    public function rules()
    {
        return [
            ['field' => 'id_dokter',
            'label' => 'Id Dokter',
            'rules' => 'required'],

            ['field' => 'nama_dokter',
            'label' => 'Nama Dokter',
            'rules' => 'required'],
            
            ['field' => 'spesialis',
            'label' => 'Spesialis',
            'rules' => 'required'],

            ['field' => 'jadwal_igd',
            'label' => 'Jadwal IGD',
            'rules' => 'required'],

            ['field' => 'jadwal_poli',
            'label' => 'Jadwal POLI',
            'rules' => 'required'],

            ['field' => 'foto_dokter',
            'label' => 'Foto Dokter',
            'rules' => 'required'],
        ];
    }

    public function getAll()
    {
        return $this->db->get($this->_table)->result();
    }
    
    public function getById($id)
    {
        return $this->db->get_where($this->_table, ["id_dokter" => $id])->row();
    }

    public function save()
    {
        $post = $this->input->post();
        $this->id_dokter = uniqid();
        $this->name_dokter = $post["nama_dokter"];
        $this->spesialis = $post["spesialis"];
        $this->jadwal_igd = $post["jadwal_igd"];
        $this->jadwal_poli = $post["jadwal_poli"];
        $this->foto_dokter = $post["foto_dokter"];
        return $this->db->insert($this->_table, $this);
    }

    public function update()
    {
        $post = $this->input->post();
        $this->id_dokter = $post["id"];
        $this->name_dokter = $post["nama_dokter"];
        $this->spesialis = $post["spesialis"];
        $this->jadwal_igd = $post["jadwal_igd"];
        $this->jadwal_poli = $post["jadwal_poli"];
        $this->foto_dokter = $post["foto_dokter"];
        return $this->db->update($this->_table, $this, array('id_dokter' => $post['id']));
    }

    public function delete($id)
    {
        return $this->db->delete($this->_table, array("id_dokter" => $id));
    }
*/
}